using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class STD_INSTITUTIONDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public STD_INSTITUTIONDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public STD_INSTITUTION GetItemComplete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            STD_INSTITUTION objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_INSTITUTION_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ID).FirstOrDefault();
                    if (objReturn != null)
                    {
                        if (objReturn.STD_FACILITYTYPE_ID > 0)
                            objReturn.STD_FACILITYTYPE = dbContext.usp_STD_FACILITYTYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STD_FACILITYTYPE_ID).FirstOrDefault();

                        if (objReturn.STREETSTATE_ID != null && objReturn.STREETSTATE_ID.Value > 0)
                            objReturn.STREETSTATE = dbContext.usp_STD_STATE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STREETSTATE_ID.Value).FirstOrDefault();

                        if (objReturn.VISN_ID != null && objReturn.VISN_ID.Value > 0)
                            objReturn.VISN = dbContext.usp_STD_INSTITUTION_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.VISN_ID.Value).FirstOrDefault();
                    }
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_INSTITUTION> GetFacs(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_INSTITUTION> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_Get_Fac().ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_INSTITUTION> GetVISNs(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_INSTITUTION> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_INSTITUTION_getVISNs(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_INSTITUTION> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_INSTITUTION> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_INSTITUTION_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_INSTITUTION> GetFacilities(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_INSTITUTION> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_INSTITUTION_getFacilities(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_INSTITUTION> GetFacilitiesShorterName(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_INSTITUTION> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_INSTITUTION_getFacilitiesShorterName(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public bool SaveVisns(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 USER_ID, List<int> visnIds)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    dbContext.usp_USER_SITES_inactivateVisns(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID);

                    foreach (int objSave in visnIds)
                    {
                        LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                        dbContext.usp_USER_SITES_saveSites(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID, objSave);
                        LogManager.LogTiming(logDetails);
                    }

                    objReturn = true;
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public bool SaveFacilities(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 USER_ID, List<int> facIds)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    dbContext.usp_USER_SITES_inactivateFacilities(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID);

                    foreach (int objSave in facIds)
                    {
                        LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                        dbContext.usp_USER_SITES_saveSites(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID, objSave);
                        LogManager.LogTiming(logDetails);
                    }

                    objReturn = true;
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_INSTITUTION> GetVisnsByUser(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 USER_ID)
        {
            List<STD_INSTITUTION> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_USER_SITES_getAllVisnsByUser(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_INSTITUTION> GetFacilitiesByUser(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 USER_ID)
        {
            List<STD_INSTITUTION> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_USER_SITES_getAllFacilitiesByUser(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public STD_INSTITUTION ParseFacs(DataRow row)
        {
            STD_INSTITUTION objReturn = new STD_INSTITUTION
            {
                FACID = row.Field<int>("FACID"),
                FACTEXT = row.Field<string>("FACTEXT"),
                STA3N = row.Field<string>("STA3N"),
                VISNSID = row.Field<int>("VISNID"),
                VISNTEXT = row.Field<string>("VISNTEXT")
            };

            return objReturn;
        }

        #endregion
    }
}
